<?php
/*--------------------------------------------------------------
   SerialItems.php 2021-06-02
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\Model\Collections;

use ArrayIterator;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Serial\Item;
use IteratorAggregate;

class SerialItems implements IteratorAggregate
{
    /**
     * @var Item[]
     */
    private $values;
    
    
    /**
     * Constructor.
     */
    private function __construct(array $values)
    {
        $this->values = $values;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(Item ...$items): self
    {
        return new self($items);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getIterator()
    {
        return new ArrayIterator($this->values);
    }
    
}